IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Rec_Fin]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cbtes_Rec_Fin] 
END
GO



CREATE PROCEDURE [dbo].[CP_Cbtes_Rec_Fin]
@pId_Trans				INT
AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/
DECLARE @Id_Cta_Contable	INT
DECLARE @Fecha				DATETIME
DECLARE @Debe				DECIMAL(12,2)
DECLARE @Haber				DECIMAL(12,2)
DECLARE @Observacion		VARCHAR(100)
DECLARE @Alias				SMALLINT
DECLARE @Id_Asiento			INT
DECLARE @Id_Centro_Costo	CHAR(10)
DECLARE @Item				SMALLINT
DECLARE @Resultado			INT

DECLARE @Descripcion_Cbte	VARCHAR(80)

DECLARE @Importe_Aplicado   DECIMAL(16,2)
DECLARE @Importe_Pago_A_Cta DECIMAL(16,2)
DECLARE @Importe_Rec		DECIMAL(16,2)
DECLARE @Imp_SP				VARCHAR(1000) 
DECLARE @Sql				VARCHAR(5000)


    /*agregado el 14/11/2020   Gaby */
DECLARE @Trans TABLE (ErrorNumber	INT 
					,ErrorSeverity  INT 
					,ErrorState		INT
					,ErrorProcedure	VARCHAR(100)
					,ErrorLine		INT
					,ErrorMessage	VARCHAR(1000)
					)


DECLARE @Mensaje			VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

--PRINT 'Procedimiento: CP_Cbtes_Rec_Fin Trans: '+ CAST(@pId_Trans AS VARCHAR(10))


    /*agregado el 14/11/2020   Gaby */
INSERT INTO @Trans
	EXEC @Resultado = dbo.CP_Cbtes_Ctas_Contables_Generar @pId_Trans, 1
IF ISNULL(@Resultado,0) <> 0 
	RETURN 9999


    /*agregado el 14/11/2020   Gaby */
INSERT INTO @Trans
	EXEC @Resultado = dbo.CP_Cbtes_Grabar_Numero @pId_Trans
IF ISNULL(@Resultado,0) <> 0 
	RETURN 9999


BEGIN TRY
	BEGIN TRAN
	
		
	SELECT @Importe_Rec = ISNULL(C.Imp_Total,0), @Imp_SP = ISNULL(T.Imp_SP,'')  FROM Cbtes C, Cbtes_Tipos T WHERE C.Id_Trans = @pId_Trans AND T.Id_Tipo_Cbte = C.Id_Tipo_Cbte
	SET @Importe_Aplicado = ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans <> 0), 0) 
	SET @Importe_Pago_A_Cta = ISNULL((SELECT SUM(Importe) FROM Cbtes_Aplica WHERE Id_Trans_D = @pId_Trans AND Id_Trans = 0), 0) 
	

	SET @Descripcion_Cbte = (dbo.CF_Cbte_Descrip(@pId_Trans))
	
	UPDATE Transacciones SET Descripcion = SUBSTRING((Descripcion + ' ' + @Descripcion_Cbte), 1, 50) WHERE Id_Trans = @pId_Trans
	UPDATE Valores SET Id_Estado_Valor = 4  WHERE Id_Trans = @pId_Trans
	UPDATE Valores_Mov SET Id_Estado_Valor = 4 WHERE Id_Trans = @pId_Trans
	UPDATE Cajas_Mov SET Id_Estado_Mov_Caja = 2, Descripcion = @Descripcion_Cbte WHERE Id_Trans = @pId_Trans

	
		
	IF(@Importe_Aplicado =  @Importe_Rec)
	BEGIN
		--Actualizar Estados/Descripcion/Saldo en Cbtes, Clientes_ctaCte, Valores, Valores_Mov, Cajas_Mov		
		UPDATE Cbtes SET Id_Estado_Cbte = 2, Saldo = 0 WHERE Id_Trans = @pId_Trans
		UPDATE Cbtes_Items SET Id_Estado_Cbte = 2 WHERE Id_Trans = @pId_Trans
		UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 2, Descripcion = @Descripcion_Cbte, Saldo = 0 WHERE Id_Trans = @pId_Trans
	END
	ELSE
	BEGIN
		IF @Importe_Pago_A_Cta + @Importe_Aplicado = @Importe_Rec
		BEGIN
			UPDATE Cbtes SET Id_Estado_Cbte = 1, Saldo = Imp_Total - @Importe_Aplicado WHERE Id_Trans = @pId_Trans       -- Pendiente
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 1, Descripcion = @Descripcion_Cbte, Saldo = Importe - @Importe_Aplicado WHERE Id_Trans = @pId_Trans
		END
		ELSE
		BEGIN
			UPDATE Cbtes SET Id_Estado_Cbte = 4, Saldo = Imp_Total - @Importe_Aplicado WHERE Id_Trans = @pId_Trans      -- Parcial
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 4, Descripcion = @Descripcion_Cbte, Saldo = Importe - @Importe_Aplicado WHERE Id_Trans = @pId_Trans
		END
	END
	
	COMMIT



    /*agregado el 9/9/2020   Gaby */
	
	IF @Imp_SP <> ''
	BEGIN	
	    SET @sql = 'EXEC '+ LTRIM(RTRIM(@Imp_SP)) +' '+ CAST(@pId_Trans AS VARCHAR(10))
		EXEC(@sql)
	END


		
	SET @Mensaje = @Descripcion_Cbte

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,@pId_Trans		AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			--,@pId_Trans		AS Id_Trans

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo; 
	IF @@TRANCOUNT > 0 	ROLLBACK
	RETURN 9999
END CATCH

--PRINT 'FIN Procedimiento: CP_Cbtes_Rec_Fin  Trans: '+ CAST(@pId_Trans AS VARCHAR(10))

RETURN 0













